							 /*****************************************************************************
 *   cantest.c:  CAN test module file for NXP LPC23xx Family Microprocessors
 *
 *   Copyright(C) 2006, NXP Semiconductor
 *   All rights reserved.
 *
 *   History
 *   2006.09.13  ver 1.00    Prelimnary version, first Release
 *
******************************************************************************/
#include "LPC23xx.h"			/* LPC23xx definitions */
#include "type.h"
#include "irq.h"
#include "can.h"
#include "target.h"

CAN_MSG MsgBuf_TX1, MsgBuf_TX2; // TX and RX Buffers for CAN message
CAN_MSG MsgBuf_RX1, MsgBuf_RX2; // TX and RX Buffers for CAN message

volatile DWORD CAN1RxDone, CAN2RxDone;

/*****************************************************************************
** Function name:		main
**
** Descriptions:		main routine for CAN module test
**
** parameters:			None
** Returned value:		int
** 
*****************************************************************************/
int main( void )
{
	int i;

	TargetResetInit();
	
	/* Please note, this PCLK is set in the target.h file. Since the example
	program is set to test USB device, there is only a limited number of
	options to set CCLK and PCLK when USB is used. The default setting is 
	CCLK 48MHz, PCLK is 1/2 CCLK 24MHz. The bit timing is based on the 
	setting of the PCLK, if different PCLK is used, please read can.h carefully 
	and set your CAN bit timing accordingly. */  
	CAN_Init( BITRATE125K24MHZ );
  
	/* This test program is connect CAN1 and CAN2 on the MCB2300 board,
	send one message from CAN1(TX) and verify received message on CAN2(RX)
	if it's a match, both CAN TX and RX are working. 
	
	For more details on acceptance filter program, see Philips
	appnote AN10438 and the zip file associated with this appnote. */

	/* Initialize MsgBuf */
	MsgBuf_TX1.Frame = 0x80080000; /* 29-bit, no RTR, DLC is 8 bytes */
	MsgBuf_TX1.MsgID = 0x00012345; /* CAN ID */
	MsgBuf_TX1.DataA = 0x3C3C3C3C;
	MsgBuf_TX1.DataB = 0xC3C3C3C3;
	CAN_SetACCF( ACCF_BYPASS );

	/* Test bypass */
	while ( 1 )
	{
		/* If you push INT0, it will send a CAN packet */
		if(!(FIO2PIN & (1<<10))){
		CAN1_SendMessage( &MsgBuf_TX1 );
		for(i = 0; i < (1<<21); i++); //Delay
		}
	}
}
/******************************************************************************
**                            End Of File
******************************************************************************/
